/* $Id: display.c,v 1.29 1999/01/20 03:03:57 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

/* This files contains all of the routines that handle displaying the
   contents of E1432 module states. */

#include "sema.h"

#ifdef WIN32
static FILE *fdout;
#endif /* WIN32 */

/*
 *********************************************************************
 Dump the contents of a group node
 *********************************************************************
 */
static void
i1432_dump_group_node(E1432_GROUP_LIST_NODE * gn)
{
    E1432_CHAN_LIST_NODE *cn;
    int     i;


#ifndef WIN32

    PRINTF(("Group Node %3d\n", gn->groupID));
    if (gn->system_mod != NULL)
	PRINTF(("  System Module      %d\n",
		gn->system_mod - i1432_mod_list + 1));
    else
	PRINTF(("  System Module      None\n"));
    if (gn->trigmn != NULL)
	PRINTF(("  Trigger Module     %d\n",
		gn->trigmn - i1432_mod_list + 1));
    else
	PRINTF(("  Trigger Module     None\n"));
    PRINTF(("  Channel List      "));
    cn = gn->chanlist;
    while (cn)
    {
	PRINTF((" %d", cn->chanID));
	cn = cn->next;
    }
    PRINTF(("\n"));
    PRINTF(("  Module Count       %d\n", gn->modcount));
    PRINTF(("  Module List       "));
    for (i = 0; i < gn->modcount; i++)
	PRINTF((" %d", gn->modlist[i] - i1432_mod_list + 1));
    PRINTF(("\n"));
    PRINTF(("  OT or RPM Arm      %d\n", gn->otra));

#else /* print to log file for WINDOWS32 */

    fprintf(fdout, "Group Node %3d\n", gn->groupID);
    if (gn->system_mod != NULL)
	fprintf(fdout, "  System Module      %d\n",
		gn->system_mod - i1432_mod_list + 1);
    else
	fprintf(fdout, "  System Module      None\n");
    if (gn->trigmn != NULL)
	fprintf(fdout, "  Trigger Module     %d\n",
		gn->trigmn - i1432_mod_list + 1);
    else
	fprintf(fdout, "  Trigger Module     None\n");
    fprintf(fdout, "  Channel List      ");
    cn = gn->chanlist;
    while (cn)
    {
	fprintf(fdout, " %d", cn->chanID);
	cn = cn->next;
    }
    fprintf(fdout, "\n");
    fprintf(fdout, "  Module Count       %d\n", gn->modcount);
    fprintf(fdout, "  Module List       ");
    for (i = 0; i < gn->modcount; i++)
	fprintf(fdout, " %d", gn->modlist[i] - i1432_mod_list + 1);
    fprintf(fdout, "\n");
    fprintf(fdout, "  OT or RPM Arm      %d\n", gn->otra);

#endif
}

/*
 *********************************************************************
 Dump all groups.
 *********************************************************************
 */
/*ARGSUSED*/
static void
i1432_dump_all_groups(E1432ID hw)
{
    E1432_GROUP_LIST_NODE *gn;

    gn = i1432_group_list;
    while (gn)
    {
	i1432_dump_group_node(gn);
	gn = gn->next;
    }
}

/*
 *********************************************************************
 Dump the contents of a channel node
 *********************************************************************
 */
static void
i1432_dump_chan_info(struct i1432_chan_info *ci, SHORTSIZ16 ID)
{
#ifndef WIN32
    PRINTF(("Channel ID %5d Module %2d Index %2d Sca %d\n", ID,
	    ci->mn - i1432_mod_list + 1, ci->index, ci->sca));
    PRINTF(("  Auto Range Mode    %d\n", ci->auto_range_mode));
    PRINTF(("  Other Channel      %d\n", ci->other_chan));
    PRINTF(("  Cached Active      %d\n", ci->active));
    PRINTF(("  Cached Calc Data   %d\n", ci->calc_data));
    PRINTF(("  Cached Scale       %g\n", ci->scale));
#else
    fprintf(fdout, "Channel ID %5d Module %2d Index %2d Sca %d\n", ID,
	    ci->mn - i1432_mod_list + 1, ci->index, ci->sca);
    fprintf(fdout, "  Auto Range Mode    %d\n", ci->auto_range_mode);
    fprintf(fdout, "  Other Channel      %d\n", ci->other_chan);
    fprintf(fdout, "  Cached Active      %d\n", ci->active);
    fprintf(fdout, "  Cached Calc Data   %d\n", ci->calc_data);
    fprintf(fdout, "  Cached Scale       %g\n", ci->scale);
#endif
}

/*
 *********************************************************************
 Dump all channels
 *********************************************************************
 */
/*ARGSUSED*/
static void
i1432_dump_all_chan_info(E1432ID hw)
{
    int type, chan;

    for (type = 0; type < E1432_CHAN_TYPES; type++)
	for (chan = 0; chan < i1432_chan_count[type]; chan++)
	    i1432_dump_chan_info(i1432_chan_list[type] + chan,
				 (SHORTSIZ16)((type << E1432_CHAN_TYPE_SHIFT)
				 + chan + 1));
}

static void
i1432_dump_mod_info(E1432_MODULE_LIST_NODE *mn, int mod)
{
#ifndef WIN32

    PRINTF(("Module Node %2d\n", mod + 1));
    PRINTF(("  HW id              0x%p\n", mn->hw));
    PRINTF(("  Logical Address    %d\n", mn->la));
    PRINTF(("  First Channel ID   %d\n", mn->chan_id));
    PRINTF(("  A24 size           %s\n", mn->a24_256k ? "256KB" : "1MB"));
    PRINTF(("  Number of Channels %d\n", mn->nchan));
    PRINTF(("  D32                %s\n", mn->d32 ? "Enabled" : "Disabled"));
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    PRINTF(("  SICL ID            %d\n", mn->sicl_id));
#endif
#ifdef	HAVE_SICL
    PRINTF(("  A24 ID Index       %d\n", mn->a24_id_index));
    PRINTF(("  A24 FIFO ID Index  %d\n", mn->a24_fifo_id_index));
    PRINTF(("  A24 FIFO Map Space %d\n", mn->a24_fifo_map_space));
    PRINTF(("  First A24 Page     0x%x\n", mn->a24_pagestart));
    PRINTF(("  A24 Pages          %d\n", mn->a24_pagecnt));
    PRINTF(("  FIFO Page          %d\n", mn->a24_fifo_pagestart));
    PRINTF(("  A24 Imap Count     %d\n", mn->a24_imap_count));
    PRINTF(("  FIFO Imap Count    %d\n", mn->a24_fifo_imap_count));
#endif
#if defined(INSTR_CALLBACKS) && defined(HAVE_VTL)
    PRINTF(("  Callback Func      0x%p\n", mn->cbFunc));
    PRINTF(("  Callback Value     %ld\n", mn->cbValue));
    PRINTF(("  Callback Handle    %ld\n", mn->cbHandle));
#endif
    PRINTF(("  A16 Base           0x%p\n", mn->a16_base));
    PRINTF(("  A24 Base           0x%p\n", mn->a24_base));
    PRINTF(("  A24 FIFO Base      0x%p\n", mn->a24_fifo_base));
#ifdef HPVXI_DOWNLOAD
    PRINTF(("  A24 Handle         0x%p\n", mn->pos_a24_handle));
#endif
    if (mn->autoGroup == E1432_AUTO_GROUP_MEAS_ON)
	PRINTF(("  Auto Group         Enabled\n"));
    else
	PRINTF(("  Auto Group         Disabled\n"));
    PRINTF(("  Request Blocksize  %ld\n", mn->rs_bsize));
    PRINTF(("  Request Navg       %ld\n", mn->rs_navg));
    PRINTF(("  Request Span       %g\n", mn->rs_span));
    PRINTF(("  Request Mag Sq     %d\n", mn->rs_magsq));
    PRINTF(("  Request Ready      %d\n", mn->rs_ready));
    PRINTF(("  Request Count      %d\n", mn->rs_req));
    PRINTF(("  Request IRQ Done   %d\n", mn->rs_irq_done));
    PRINTF(("  Request IRQ Error  %d\n", mn->rs_irq_error));
    PRINTF(("  Request IRQ ID     %d\n", mn->rs_irq_id));
    PRINTF(("  Request IRQ Off    %d\n", mn->rs_irq_off));
    PRINTF(("  Request IRQ Line   %d\n", mn->rs_irq_save_line));
    PRINTF(("  Request IRQ Mask   %d\n", mn->rs_irq_save_mask));
#ifdef	HAVE_SICL
    PRINTF(("  Request IRQ ID     %d\n", mn->rs_irq_sicl_id));
#endif
    PRINTF(("  Cached Blocksize   %ld\n", mn->blocksize));
    PRINTF(("  Cached Append Stat %d\n", mn->append_status));
    PRINTF(("  Cached Data Size   %d\n", mn->data_size));
    PRINTF(("  Cached Meas Type   %d\n", mn->meas_type));
    PRINTF(("  Cached Freq Mag Sq %d\n", mn->freq_mag_squared));
    PRINTF(("  Cached Zoom        %d\n", mn->zoom));
    PRINTF(("  Cached Order Track %d\n", mn->order_tracking));
    PRINTF(("  Cached RPM Arm     %d\n", mn->rpm_arm));

#else	/* WIN32 */

    fprintf(fdout, "Module Node %2d\n", mod + 1);
    fprintf(fdout, "  HW id              0x%p\n", mn->hw);
    fprintf(fdout, "  Logical Address    %d\n", mn->la);
    fprintf(fdout, "  First Channel ID   %d\n", mn->chan_id);
    fprintf(fdout, "  A24 size           %s\n",
	    mn->a24_256k ? "256KB" : "1MB");
    fprintf(fdout, "  Number of Channels %d\n", mn->nchan);
    if (mn->d32)
	fprintf(fdout, "  D32                Enabled\n");
    else
	fprintf(fdout, "  D32                Disabled\n");
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    fprintf(fdout, "  SICL ID            %d\n", mn->sicl_id);
#endif
#ifdef	HAVE_SICL
    fprintf(fdout, "  A24 ID Index       %d\n", mn->a24_id_index);
    fprintf(fdout, "  A24 FIFO ID Index  %d\n", mn->a24_fifo_id_index);
    fprintf(fdout, "  A24 FIFO Map Space %d\n", mn->a24_fifo_map_space);
    fprintf(fdout, "  First A24 Page     0x%x\n", mn->a24_pagestart);
    fprintf(fdout, "  A24 Pages          %d\n", mn->a24_pagecnt);
    fprintf(fdout, "  FIFO Page          %d\n", mn->a24_fifo_pagestart);
    fprintf(fdout, "  A24 Imap Count     %d\n", mn->a24_imap_count);
    fprintf(fdout, "  FIFO Imap Count    %d\n", mn->a24_fifo_imap_count);
#endif
#if defined(INSTR_CALLBACKS) && defined(HAVE_VTL)
    fprintf(fdout, "  Callback Func      0x%p\n", mn->cbFunc);
    fprintf(fdout, "  Callback Value     %ld\n", mn->cbValue);
    fprintf(fdout, "  Callback Handle    %ld\n", mn->cbHandle);
#endif
    fprintf(fdout, "  A16 Base           0x%p\n", mn->a16_base);
    fprintf(fdout, "  A24 Base           0x%p\n", mn->a24_base);
    fprintf(fdout, "  A24 FIFO Base      0x%p\n", mn->a24_fifo_base);
#ifdef HPVXI_DOWNLOAD
    fprintf(fdout, "  A24 Handle         0x%p\n", mn->pos_a24_handle);
#endif
    if (mn->autoGroup == E1432_AUTO_GROUP_MEAS_ON)
	fprintf(fdout, "  Auto Group         Enabled\n");
    else
	fprintf(fdout, "  Auto Group         Disabled\n");
    fprintf(fdout, "  Request Blocksize  %ld\n", mn->rs_bsize);
    fprintf(fdout, "  Request Navg       %ld\n", mn->rs_navg);
    fprintf(fdout, "  Request Span       %g\n", mn->rs_span);
    fprintf(fdout, "  Request Mag Sq     %d\n", mn->rs_magsq);
    fprintf(fdout, "  Request Ready      %d\n", mn->rs_ready);
    fprintf(fdout, "  Request Count      %d\n", mn->rs_req);
    fprintf(fdout, "  Request IRQ Done   %d\n", mn->rs_irq_done);
    fprintf(fdout, "  Request IRQ Error  %d\n", mn->rs_irq_error);
    fprintf(fdout, "  Request IRQ ID     %d\n", mn->rs_irq_id);
    fprintf(fdout, "  Request IRQ Off    %d\n", mn->rs_irq_off);
    fprintf(fdout, "  Request IRQ Line   %d\n", mn->rs_irq_save_line);
    fprintf(fdout, "  Request IRQ Mask   %d\n", mn->rs_irq_save_mask);
#ifdef	HAVE_SICL
    fprintf(fdout, "  Request IRQ ID     %d\n", mn->rs_irq_sicl_id);
#endif
    fprintf(fdout, "  Cached Blocksize   %ld\n", mn->blocksize);
    fprintf(fdout, "  Cached Append Stat %d\n", mn->append_status);
    fprintf(fdout, "  Cached Data Size   %d\n", mn->data_size);
    fprintf(fdout, "  Cached Meas Type   %d\n", mn->meas_type);
    fprintf(fdout, "  Cached Freq Mag Sq %d\n", mn->freq_mag_squared);
    fprintf(fdout, "  Cached Zoom        %d\n", mn->zoom);
    fprintf(fdout, "  Cached Order Track %d\n", mn->order_tracking);
    fprintf(fdout, "  Cached RPM Arm     %d\n", mn->rpm_arm);

#endif	/* WIN32 */
}

/*ARGSUSED*/
static void
i1432_dump_all_mod_info(E1432ID hw)
{
    E1432_MODULE_LIST_NODE *mn;
    int     mod;

    mn = i1432_mod_list;
    for (mod = 0; mod < i1432_mod_count; mod++, mn++)
	i1432_dump_mod_info(mn, mod);
}

/*ARGSUSED*/
static void
i1432_dump_iopen_list_info(E1432ID hw)
{
#ifdef	HAVE_SICL
    int     i;

#ifndef	WIN32

    PRINTF(("  Iopen List Name    %s\n",
	    i1432_iopen_list_info.name != NULL ?
	    i1432_iopen_list_info.name : "NULL"));
    PRINTF(("  Iopen List Nid     %d\n", i1432_iopen_list_info.nid));
    PRINTF(("  Iopen List ID    "));
    for (i = 0; i < i1432_iopen_list_info.nid; i++)
	PRINTF((" %2d", i1432_iopen_list_info.id[i]));
    PRINTF(("\n"));
    PRINTF(("  Iopen List Avail "));
    for (i = 0; i < i1432_iopen_list_info.nid; i++)
	PRINTF((" %2d", i1432_iopen_list_info.avail[i]));
    PRINTF(("\n"));

#else	/* WIN32 */

    fprintf(fdout, "  Iopen List Name    %s\n",
	    i1432_iopen_list_info.name != NULL ?
	    i1432_iopen_list_info.name : "NULL");
    fprintf(fdout, "  Iopen List Nid     %d\n", i1432_iopen_list_info.nid);
    fprintf(fdout, "  Iopen List ID    ");
    for (i = 0; i < i1432_iopen_list_info.nid; i++)
	fprintf(fdout, " %2d", i1432_iopen_list_info.id[i]);
    fprintf(fdout, "\n");
    fprintf(fdout, "  Iopen List Avail ");
    for (i = 0; i < i1432_iopen_list_info.nid; i++)
	fprintf(fdout, " %2d", i1432_iopen_list_info.avail[i]);
    fprintf(fdout, "\n");

#endif	/* WIN32 */
#endif	/* SICL */
}

/*ARGSUSED*/
static void
i1432_dump_global_info(E1432ID hw)
{
#ifndef	WIN32

#ifdef	HAVE_SIGBUS
    PRINTF(("Global E1432 Library Info\n"));
    PRINTF(("  Buserr Env Valid   %d\n", i1432_buserr_env_valid));
    PRINTF(("  Buserr Trap        %d\n", i1432_buserr_trap));
#endif
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    PRINTF(("  Sicl Name          %s\n", i1432_sicl_name));
    PRINTF(("  Sicl ID            %d\n", i1432_sicl_id));
    PRINTF(("  A16 Base           0x%p\n", i1432_a16_base));
#endif
#ifdef	HAVE_SICL
    PRINTF(("  A16 ID Index       %d\n", i1432_a16_id_index));
    PRINTF(("  Have A24_D32       %d\n", i1432_have_a24_d32));
#endif
    PRINTF(("  Lib Init           %d\n", i1432_lib_init));
    PRINTF(("  Trace Level        %d\n", i1432_trace_level));
    PRINTF(("  Print Reg Access   %d\n", i1432_print_reg_access));
    PRINTF(("  Print Errors       %d\n", i1432_print_errors));
    PRINTF(("  Install File       %s\n",
	    i1432_install_file != NULL ? i1432_install_file : "NULL"));
    PRINTF(("  Install From Mem   %d\n", i1432_install_from_mem));
    PRINTF(("  Diag Print Level   %d\n", i1432_diag_print_level));
    PRINTF(("  Trigger Sent       %d\n", i1432_trigger_sent));
    PRINTF(("  Kludge DatRPM Flag %d\n", i1432_kludge_data_rpm_flag));
    PRINTF(("  Kludge DatRPM Id1  %d\n", i1432_kludge_data_rpm_id1));
    PRINTF(("  Kludge DatRPM RPM1 %g\n", i1432_kludge_data_rpm1));
    PRINTF(("  Kludge DatRPM RPM2 %g\n", i1432_kludge_data_rpm2));
    PRINTF(("  Kludge Enable Flag %d\n", i1432_kludge_enable_flag));
    PRINTF(("  Kludge Tach Flag   %d\n", i1432_kludge_tach_flag));
    PRINTF(("  Mod Opt List       %s\n", i1432_mod_opt_list));
    PRINTF(("  Request IRQ Error  %d\n", i1432_rs_irq_error));
#ifdef	HAVE_VTL
    PRINTF(("  VISA D16 Flag      %d\n", i1432_visa_d16));
    PRINTF(("  VISA Introff Count %d\n", i1432_visa_introff_count));
    PRINTF(("  VISA Lock Mode     %d\n", i1432_visa_lock_mode));
#endif
#ifdef	HPVXI_DOWNLOAD
    PRINTF(("  Ocas Flag          %d\n", ocas_flag));
    PRINTF(("  Device Clear Flag  %d\n", device_clear_flag));
    PRINTF(("  Output Buffer      0x%p\n", i1432_output_buffer));
    PRINTF(("  Format Scaling     %d\n", formatscaling));
    PRINTF(("  Format Type        %d\n", formattype));
    PRINTF(("  Next Chan Read     %d\n", nextchanread));
    PRINTF(("  Logical Address    %d\n", i1432_la));
#endif

#else	/* WIN32 */

#ifdef	HAVE_SIGBUS
    fprintf(fdout, "Global E1432 Library Info\n");
    fprintf(fdout, "  Buserr Env Valid   %d\n", i1432_buserr_env_valid);
    fprintf(fdout, "  Buserr Trap        %d\n", i1432_buserr_trap);
#endif
#if defined(HAVE_SICL) || defined(HAVE_VTL)
    fprintf(fdout, "  Sicl Name          %s\n", i1432_sicl_name);
    fprintf(fdout, "  Sicl ID            %d\n", i1432_sicl_id);
    fprintf(fdout, "  A16 Base           0x%p\n", i1432_a16_base);
#endif
#ifdef	HAVE_SICL
    fprintf(fdout, "  A16 ID Index       %d\n", i1432_a16_id_index);
    fprintf(fdout, "  Have A24_D32       %d\n", i1432_have_a24_d32);
#endif
    fprintf(fdout, "  Lib Init           %d\n", i1432_lib_init);
    fprintf(fdout, "  Trace Level        %d\n", i1432_trace_level);
    fprintf(fdout, "  Print Reg Access   %d\n", i1432_print_reg_access);
    fprintf(fdout, "  Print Errors       %d\n", i1432_print_errors);
    fprintf(fdout, "  Install File       %s\n",
	    i1432_install_file != NULL ? i1432_install_file : "NULL");
    fprintf(fdout, "  Install From Mem   %d\n", i1432_install_from_mem);
    fprintf(fdout, "  Diag Print Level   %d\n", i1432_diag_print_level);
    fprintf(fdout, "  Trigger Sent       %d\n", i1432_trigger_sent);
    fprintf(fdout, "  Kludge DatRPM Flag %d\n", i1432_kludge_data_rpm_flag);
    fprintf(fdout, "  Kludge DatRPM Id1  %d\n", i1432_kludge_data_rpm_id1);
    fprintf(fdout, "  Kludge DatRPM RPM1 %g\n", i1432_kludge_data_rpm1);
    fprintf(fdout, "  Kludge DatRPM RPM2 %g\n", i1432_kludge_data_rpm2);
    fprintf(fdout, "  Kludge Enable Flag %d\n", i1432_kludge_enable_flag);
    fprintf(fdout, "  Kludge Tach Flag   %d\n", i1432_kludge_tach_flag);
    fprintf(fdout, "  Mod Opt List       %s\n", i1432_mod_opt_list);
    fprintf(fdout, "  Request IRQ Error  %d\n", i1432_rs_irq_error);
#ifdef	HAVE_VTL
    fprintf(fdout, "  VISA D16 Flag      %d\n", i1432_visa_d16);
    fprintf(fdout, "  VISA Introff Count %d\n", i1432_visa_introff_count);
    fprintf(fdout, "  VISA Lock Mode     %d\n", i1432_visa_lock_mode);
#endif
#ifdef	HPVXI_DOWNLOAD
    fprintf(fdout, "  Ocas Flag          %d\n", ocas_flag);
    fprintf(fdout, "  Device Clear Flag  %d\n", device_clear_flag);
    fprintf(fdout, "  Output Buffer      0x%p\n", i1432_output_buffer);
    fprintf(fdout, "  Format Scaling     %d\n", formatscaling);
    fprintf(fdout, "  Format Type        %d\n", formattype);
    fprintf(fdout, "  Next Chan Read     %d\n", nextchanread);
    fprintf(fdout, "  Logical Address    %d\n", i1432_la);
#endif

#endif	/* WIN32 */
}

/*
 *********************************************************************
 Dump global info, and the state of all modules, groups, and channels.
 *********************************************************************
 */
SHORTSIZ16 EXPORT
e1432_display_state(E1432ID hw)
{
#ifdef	WIN32
    fdout=fopen("C:\\e1432log","a");
    if(!fdout)
      return 0;
#endif

    i1432_dump_global_info(hw);
    i1432_dump_iopen_list_info(hw);
    i1432_dump_all_mod_info(hw);
    i1432_dump_all_groups(hw);
    i1432_dump_all_chan_info(hw);

#ifdef	WIN32
    fclose(fdout);
#endif

    return 0;
}
